<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PayoutMethod extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sql = "INSERT INTO `payout_methods` (`id`, `name`, `code`, `description`, `bank_name`, `banks`, `parameters`, `extra_parameters`, `inputForm`, `currency_lists`, `supported_currency`, `payout_currencies`, `is_active`, `is_automatic`, `is_sandbox`, `environment`, `confirm_payout`, `is_auto_update`, `currency_type`, `logo`, `driver`, `created_at`, `updated_at`) VALUES
            (2, 'Bank Transfer', 'paypal-manual', 'Payment will receive within 9 hours', NULL, NULL, '[]', NULL, '{\"account_name\":{\"field_name\":\"account_name\",\"field_label\":\"Account Name\",\"type\":\"text\",\"validation\":\"required\"},\"account_details\":{\"field_name\":\"account_details\",\"field_label\":\"Account Details\",\"type\":\"textarea\",\"validation\":\"required\"},\"n_i_d\":{\"field_name\":\"n_i_d\",\"field_label\":\"NID\",\"type\":\"file\",\"validation\":\"required\"}}', NULL, '[\"EUR\",\"CAD\"]', '[{\"currency_symbol\":\"EUR\",\"conversion_rate\":\"0.0081\",\"min_limit\":\"1\",\"max_limit\":\"10000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"currency_symbol\":\"CAD\",\"conversion_rate\":\"0.013\",\"min_limit\":\"1\",\"max_limit\":\"10000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"}]', 1, 0, 0, 'test', 1, 0, 1, 'payoutMethod/ak6zVFBh2VA9vLBwxKOZad8rklp79E4lO4P8aTji.png', 'local', '2020-12-23 07:40:51', '2023-11-25 21:10:25'),
            (3, 'Bank', 'bank', 'Payment will receive within 8 days', NULL, NULL, '[]', NULL, '{\"d\":{\"field_name\":\"d\",\"field_label\":\"d\",\"type\":\"text\",\"validation\":\"required\"},\"f\":{\"field_name\":\"f\",\"field_label\":\"f\",\"type\":\"text\",\"validation\":\"required\"}}', NULL, '[\"HUR\"]', '[{\"currency_symbol\":\"HUR\",\"conversion_rate\":\"100\",\"min_limit\":\"1\",\"max_limit\":\"1000\",\"percentage_charge\":\"1.2\",\"fixed_charge\":\"2\"}]', 0, 0, 0, 'test', 1, 0, 1, NULL, 'local', '2020-12-27 07:23:36', '2023-09-29 22:31:22'),
            (9, 'Flutterwave', 'flutterwave', 'Payment will receive within 1 days', '{\"0\":{\"NGN BANK\":\"NGN BANK\",\"NGN DOM\":\"NGN DOM\",\"GHS BANK\":\"GHS BANK\",\"KES BANK\":\"KES BANK\",\"ZAR BANK\":\"ZAR BANK\",\"INTL EUR & GBP\":\"INTL EUR & GBP\",\"INTL USD\":\"INTL USD\",\"INTL OTHERS\":\"INTL OTHERS\",\"FRANCOPGONE\":\"FRANCOPGONE\",\"XAF/XOF MOMO\":\"XAF/XOF MOMO\",\"mPesa\":\"mPesa\",\"Rwanda Momo\":\"Rwanda Momo\",\"Uganda Momo\":\"Uganda Momo\",\"Zambia Momo\":\"Zambia Momo\",\"Barter\":\"Barter\",\"FLW\":\"FLW\"}}', '[\"NGN BANK\",\"NGN DOM\",\"GHS BANK\"]', '{\"Public_Key\":\"FLWPUBK_TEST-5003321b93b251536fd2e7e05232004f-X\",\"Secret_Key\":\"FLWSECK_TEST-d604361e2d4962f4bb2a400c5afefab1-X\",\"Encryption_Key\":\"FLWSECK_TEST817a365e142b\"}', NULL, '[]', '{\"USD\":\"USD\",\"KES\":\"KES\",\"GHS\":\"GHS\",\"NGN\":\"NGN\",\"GBP\":\"GBP\",\"EUR\":\"EUR\",\"UGX\":\"UGX\",\"TZS\":\"TZS\"}', '[\"USD\",\"KES\",\"NGN\"]', '[{\"name\":\"USD\",\"currency_symbol\":\"KES\",\"conversion_rate\":\"1.38\",\"min_limit\":\"10\",\"max_limit\":\"15000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"name\":\"KES\",\"currency_symbol\":\"USD\",\"conversion_rate\":\"0.0091\",\"min_limit\":\"10\",\"max_limit\":\"10000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"name\":\"NGN\",\"currency_symbol\":\"AUD\",\"conversion_rate\":\"0.014\",\"min_limit\":\"10\",\"max_limit\":\"100000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"}]', 1, 1, 0, 'test', 1, 0, 1, 'payoutMethod/3ZHEVOuAMEKXfG2oeGesEkMEXua0isCJPDFbn6Ix.jpg', 'local', '2020-12-27 07:23:36', '2023-11-25 21:05:28'),
            (10, 'Razorpay', 'razorpay', 'Payment will receive within 1 days', '', NULL, '{\"account_number\":\"7878780080316316\",\"Key_Id\":\"rzp_test_kiOtejPbRZU90E\",\"Key_Secret\":\"osRDebzEqbsE1kbyQJ4y0re7\"}', '{\"webhook\":\"payout\"}', '[]', '{\"INR\":\"INR\"}', '[\"INR\"]', '[{\"name\":\"INR\",\"currency_symbol\":\"INR\",\"conversion_rate\":\"0.76\",\"min_limit\":\"10\",\"max_limit\":\"15000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"}]', 1, 1, 0, 'test', 1, 0, 1, 'payoutMethod/KzWb68n0qIkz998tUDeiTj5T45idCJ7Vsz5rVr6O.jpg', 'local', '2020-12-27 07:23:36', '2023-11-25 21:06:00'),
            (11, 'Paystack', 'paystack', 'Payment will receive within 1 days', '', NULL, '{\"Public_key\":\"pk_test_60368e68f65e34c4c3076334de0350fdb78c942b\",\"Secret_key\":\"sk_test_afe163363398a752b856d01e2b7be2554d9a2330\"}', '{\"webhook\":\"payout\"}', '[]', '{\"NGN\":\"NGN\",\"GHS\":\"GHS\",\"ZAR\":\"ZAR\"}', '[\"NGN\",\"GHS\",\"ZAR\"]', '[{\"name\":\"NGN\",\"currency_symbol\":\"NGN\",\"conversion_rate\":\"7.40\",\"min_limit\":\"50\",\"max_limit\":\"50000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"name\":\"GHS\",\"currency_symbol\":\"GHS\",\"conversion_rate\":\"0.11\",\"min_limit\":\"50\",\"max_limit\":\"50000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"name\":\"ZAR\",\"currency_symbol\":\"ZAR\",\"conversion_rate\":\"0.17\",\"min_limit\":\"50\",\"max_limit\":\"50000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"}]', 1, 1, 0, 'test', 1, 1, 1, 'payoutMethod/R171DPtw6jtQL7tvf9NR2gtnwhMTRpFlW51aPjKP.png', 'local', '2020-12-27 07:23:36', '2023-11-25 21:07:02'),
            (12, 'Coinbase', 'coinbase', 'Payment will receive within 1 days', '', NULL, '{\"API_Key\":\"5328e8ff2f7fe0bbc7fd6ea593038b08\",\"API_Secret\":\"ACWAncjv2fbMdvPfeJq9U\\/blqEx1FiItqbUGn+kEPCLbKGP4\\/iJlPIQDzMmJHHz\\/Inv1jYANsWDnh3RhHi6HLw==\",\"Api_Passphrase\":\"23xe3opufifi\"}', '{\"webhook\":\"payout\"}', '{\"crypto_address\":{\"field_name\":\"crypto_address\",\"field_label\":\"Crypto Address\",\"type\":\"text\",\"validation\":\"required\"}}', '{\"BNB\":\"BNB\",\"BTC\":\"BTC\",\"XRP\":\"XRP\",\"ETH\":\"ETH\",\"ETH2\":\"ETH2\",\"USDT\":\"USDT\",\"BCH\":\"BCH\",\"LTC\":\"LTC\",\"XMR\":\"XMR\",\"TON\":\"TON\"}', '[\"BNB\"]', '[{\"name\":\"BNB\",\"currency_symbol\":\"BNB\",\"conversion_rate\":\"0.068\",\"min_limit\":\"1000\",\"max_limit\":\"1000000\",\"percentage_charge\":\"0.5\",\"fixed_charge\":\"0.5\"}]', 1, 1, 0, 'test', 1, 0, 1, 'payoutMethod/moST8wELN5rooqTg1jO5KBeKPrpOn2be3FNeUziY.png', 'local', '2020-12-27 07:23:36', '2023-10-13 20:13:57'),
            (14, 'Perfect Money', 'perfectmoney', 'Payment will receive within 1 days', '', NULL, '{\"Passphrase\":\"45P7GN1T8TlRfMRAPCqLArVHz\",\"Account_ID\":\"90016052\",\"Payer_Account\":\"U41722458\"}', '', '[]', '{\"USD\":\"USD\",\"EUR\":\"EUR\"}', '[\"USD\",\"EUR\"]', '[{\"name\":\"USD\",\"currency_symbol\":\"USD\",\"conversion_rate\":\"0.0091\",\"min_limit\":\"1\",\"max_limit\":\"15000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"},{\"name\":\"EUR\",\"currency_symbol\":\"EUR\",\"conversion_rate\":\"0.0081\",\"min_limit\":\"1\",\"max_limit\":\"15000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0.5\"}]', 1, 1, 0, 'test', 1, 1, 1, 'payoutMethod/Y7nhbYHjmNnKXDFPQfCBbmGpHvrjH6L8clZXrLrX.jpg', 'local', '2020-12-27 07:23:36', '2023-11-25 21:08:39'),
            (15, 'Paypal', 'paypal', 'Payment will receive within 1 days', '', NULL, '{\"cleint_id\":\"AUrvcotEVWZkksiGir6Ih4PyalQcguQgGN-7We5O1wBny3tg1w6srbQzi6GQEO8lP3yJVha2C6lyivK9\",\"secret\":\"EPx-YEgvjKDRFFu3FAsMue_iUMbMH6jHu408rHdn4iGrUCM8M12t7mX8hghUBAWwvWErBOa4Uppfp0Eh\"}', '{\"webhook\":\"payout\"}', '[]', '{\"AUD\":\"AUD\",\"BRL\":\"BRL\",\"CAD\":\"CAD\",\"CZK\":\"CZK\",\"DKK\":\"DKK\",\"EUR\":\"EUR\",\"HKD\":\"HKD\",\"HUF\":\"HUF\",\"INR\":\"INR\",\"ILS\":\"ILS\",\"JPY\":\"JPY\",\"MYR\":\"MYR\",\"MXN\":\"MXN\",\"TWD\":\"TWD\",\"NZD\":\"NZD\",\"NOK\":\"NOK\",\"PHP\":\"PHP\",\"PLN\":\"PLN\",\"GBP\":\"GBP\",\"RUB\":\"RUB\",\"SGD\":\"SGD\",\"SEK\":\"SEK\",\"CHF\":\"CHF\",\"THB\":\"THB\",\"USD\":\"USD\"}', '[\"EUR\",\"USD\"]', '[{\"name\":\"EUR\",\"currency_symbol\":\"EUR\",\"conversion_rate\":\"0.0081\",\"min_limit\":\"1\",\"max_limit\":\"1000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0\"},{\"name\":\"USD\",\"currency_symbol\":\"USD\",\"conversion_rate\":\"0.0091\",\"min_limit\":\"1\",\"max_limit\":\"1000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0\"}]', 1, 1, 1, 'test', 1, 0, 1, 'payoutMethod/UZ9Ask4ycKIT1XML896p035iDb1f3wGm5HebFALO.png', 'local', '2020-12-27 07:23:36', '2023-11-25 21:09:10'),
            (16, 'Binance', 'binance', 'Payment will receive within 1 days', '', NULL, '{\"API_Key\":\"u7UxJbqJvYKlhygtR0wlC5xOfWWIuNMUHqZrPXkwLC0neRRrC5HHq7CnbdKWacBI\",\"KEY_Secret\":\"5Z00Ecib1MBnGoHs2LxdqPCE4c4UvQ4vZKEweLmySWhvw5jM4BV2nnk0sWL9gNEL\"}', '', '[]', '{\"BNB\":\"BNB\",\"BTC\":\"BTC\",\"XRP\":\"XRP\",\"ETH\":\"ETH\",\"ETH2\":\"ETH2\",\"USDT\":\"USDT\",\"BCH\":\"BCH\",\"LTC\":\"LTC\",\"XMR\":\"XMR\",\"TON\":\"TON\"}', '[\"BNB\"]', '[{\"name\":\"BNB\",\"currency_symbol\":\"BNB\",\"conversion_rate\":\"0.0043\",\"min_limit\":\"10\",\"max_limit\":\"1000\",\"percentage_charge\":\"0\",\"fixed_charge\":\"0\"}]', 1, 1, 1, 'test', 1, 0, 1, 'payoutMethod/X6ZKvtR4xcxlSnHKS8FZQuTmOQy270hOyPeUbmSh.png', 'local', '2020-12-27 07:23:36', '2023-11-25 21:09:46')";
        DB::unprepared($sql);
    }
}
